if (UnitLevel("player") < 75) then
	return;
end

local UPDATE_INTERVAL = 5;
local nextUpdate = UPDATE_INTERVAL;
local timeOfNextWintergraspPvP = -1;

WgClock = CreateFrame("Frame");

local filled = false;
local timesIndex = 1;
local timesTable = {};
local function GetWintergraspAverage(remainingTime)
	timesTable[timesIndex] = remainingTime;
	if (timesIndex > 5) then
		timesIndex = 1;
		filled = true;
	else
		timesIndex = timesIndex + 1;
		if (not filled) then
			return remainingTime;
		end
	end
	-- We have a full table
	local newRemainingTime = ((timesTable[1] + timesTable[2] + timesTable[3] + timesTable[4] + timesTable[5]) / 5);
	if (newRemainingTime > (remainingTime + 3)) or (newRemainingTime < (remainingTime - 3)) then
		-- Way off, Resets
		filled = false;
		timesIndex = 1;
		timesTable = {};
		return remainingTime;
	end
	return newRemainingTime;
end

function WgClock.Notify(msg)
	--PlaySound("GnomeExploration")
	PlaySound("PVPTHROUGHQUEUE");
	if SCT_Display then -- send via SCT if it exists
		SCT_Display(msg,{r=.2,g=.7,b=.9})
	elseif SHOW_COMBAT_TEXT=="1" then
		CombatText_AddMessage(msg, CombatText_StandardScroll, .2, .7, .9) -- or default UI's SCT
	else
		-- send vis UIErrorsFrame if neither SCT exists
		UIErrorsFrame:AddMessage(msg,.2,.7,.9,1,UIERRORS_HOLD_TIME)
	end
	DEFAULT_CHAT_FRAME:AddMessage("|cff33b2e5"..msg)
end

local function IsMatchingTime(seconds)
	if (seconds <= 3600) and (seconds > 3595) then
		return true;
	end
	if (seconds <= 1800) and (seconds > 1795) then
		return true;
	end
	if (seconds <= 900) and (seconds > 895) then
		return true;
	end
	if (seconds <= 600) and (seconds > 595) then
		return true;
	end
	if (seconds <= 300) and (seconds > 295) then
		return true;
	end
	if (seconds <= 180) and (seconds > 175) then
		return true;
	end
	if (seconds <= 60) and (seconds > 55) then
		return true;
	end
end

local flip = true;
function WgClock.IsTime()
	-- time until next Wintergrasp PvP
	if (timeOfNextWintergraspPvP == nil) then
		-- In-Progress
		return nil;
	else
		local remainingTime = (timeOfNextWintergraspPvP	- GetTime());
		if (timeOfNextWintergraspPvp ~= -1) and (remainingTime >= 0) then
			if (IsMatchingTime(remainingTime)) then
				return math.ceil(remainingTime / 60);
			end
		else
			return nil;
		end
	end
	return nil;
end

WgClock:SetScript("OnUpdate", function (self, elapsed)
	nextUpdate = (nextUpdate - elapsed);
	if (nextUpdate <= 0) then
		local wgTime = GetWintergraspWaitTime();
		local name, type, difficulty, difficultyName = GetInstanceInfo();
		if (wgTime) then
			timeOfNextWintergraspPvP = GetTime() + wgTime; -- Time Remaining
		elseif (name == "Northrend") then
			timeOfNextWintergraspPvP = nil; -- In-Progress
		else
			timeOfNextWintergraspPvP = -1; -- Unknown
		end
		local time = WgClock.IsTime();
		if (time) then
			WgClock.Notify("You have "..tostring(time).." minutes until the next Wintergrasp");
		end
		nextUpdate = UPDATE_INTERVAL;
	end
end);

WgClock:Show();
