﻿-- ------------------------------------------------------------------------------------- --
-- 					TradeSkillMaster_Crafting - AddOn by Sapu94							 	  	  --
--   http://wow.curse.com/downloads/wow-addons/details/tradeskillmaster_crafting.aspx    --
--																													  --
--		This addon is licensed under the CC BY-NC-ND 3.0 license as described at the		  --
--				following url: http://creativecommons.org/licenses/by-nc-nd/3.0/			 	  --
-- 	Please contact the author via email at sapu94@gmail.com with any questions or		  --
--		concerns regarding this license.																	  --
-- ------------------------------------------------------------------------------------- --

-- The following functions are contained attached to this file:
-- Enchanting:HasProfession() - determines if the player is an enchanter

-- The following "global" (within the addon) variables are initialized in this file:
-- Enchanting.vellumID - itemID for Enchanting Vellum
-- Enchanting.slot - hardcoded list of the slot of every craft

-- ===================================================================================== --


-- load the parent file (TSM) into a local variable and register this file as a module
local TSM = select(2, ...)
local L = LibStub("AceLocale-3.0"):GetLocale("TradeSkillMaster_Crafting") -- loads the localization table
local Enchanting = TSM:NewModule("Enchanting", "AceEvent-3.0")

local debug = function(...) TSM:Debug(...) end -- for debugging

-- determines if the player is an enchanter
function Enchanting:HasProfession()
	local professionIDs = {7411, 7412, 7413, 13920, 28029, 51313, 74258}
	for _, id in pairs(professionIDs) do
		if IsSpellKnown(id) then return true end
	end
end

function Enchanting:GetSlot(itemID)
	if not itemID then return end
	return Enchanting.slot[itemID] or #Enchanting.slotList
end

Enchanting.vellumID = 38682

Enchanting.slotList = {L["2H Weapon"], L["Boots"], L["Bracers"], L["Chest"], L["Cloak"], L["Gloves"], L["Shield"], L["Staff"], L["Weapon"], L["Other"]}

-- looks up the itemID of the scroll that the enchant makes
-- index = spellID of the enchant
-- value = itemID of scroll
Enchanting.itemID = {
	[44488] = 38953,
	[7426] = 38767,
	[42974] = 38948,
	[7428] = 38768,
	[44528] = 38966,
	[60609] = 44456,
	[13815] = 38827,
	[13817] = 38828,
	[59621] = 44493,
	[44584] = 38974,
	[44592] = 38979,
	[27899] = 38897,
	[22750] = 38878,
	[44616] = 38987,
	[20031] = 38870,
	[7443] = 38769,
	[46578] = 38998,
	[20010] = 38854,
	[13841] = 38831,
	[25073] = 38886,
	[23802] = 38882,
	[25081] = 38891,
	[13898] = 38838,
	[44513] = 38964,
	[33994] = 38932,
	[34002] = 38938,
	[7454] = 38770,
	[13695] = 38822,
	[27914] = 38902,
	[20013] = 38857,
	[20017] = 38861,
	[13612] = 38800,
	[20025] = 38865,
	[20029] = 38868,
	[20033] = 38872,
	[13620] = 38802,
	[27946] = 38906,
	[27950] = 38909,
	[27954] = 38910,
	[27958] = 38912,
	[27962] = 38915,
	[13887] = 38836,
	[44593] = 38980,
	[13655] = 38814,
	[13635] = 38806,
	[13640] = 38808,
	[44625] = 38990,
	[13644] = 38810,
	[13646] = 38811,
	[13648] = 38812,
	[13905] = 38839,
	[13538] = 38798,
	[13421] = 38790,
	[7857] = 38782,
	[64579] = 46098,
	[13915] = 38840,
	[13917] = 38841,
	[34003] = 38939,
	[7766] = 38774,
	[7420] = 38766,
	[27968] = 38918,
	[47900] = 39005,
	[7745] = 38772,
	[44506] = 38960,
	[13933] = 38843,
	[13935] = 38844,
	[13937] = 38845,
	[13939] = 38846,
	[13941] = 38847,
	[13943] = 38848,
	[13945] = 38849,
	[13947] = 38850,
	[25074] = 38887,
	[20014] = 38858,
	[13698] = 38823,
	[13700] = 38824,
	[44595] = 38981,
	[44582] = 38973,
	[60691] = 44463,
	[13536] = 38797,
	[60707] = 44466,
	[44575] = 44815,
	[44555] = 38968,
	[23799] = 38879,
	[25078] = 38888,
	[25082] = 38892,
	[25086] = 38895,
	[60763] = 44469,
	[33996] = 38934,
	[34004] = 38940,
	[60616] = 38971,
	[27911] = 38900,
	[44483] = 38950,
	[7776] = 38776,
	[33995] = 38933,
	[13485] = 38792,
	[7779] = 38777,
	[20030] = 38869,
	[13746] = 38825,
	[7782] = 38778,
	[27947] = 38907,
	[27951] = 37603,
	[27984] = 38925,
	[13501] = 38793,
	[13503] = 38794,
	[7788] = 38780,
	[27971] = 38919,
	[60668] = 44458,
	[27967] = 38917,
	[27913] = 38901,
	[60692] = 44465,
	[44635] = 38997,
	[44489] = 38954,
	[7786] = 38779,
	[28003] = 38926,
	[20009] = 38853,
	[13890] = 38837,
	[13529] = 38796,
	[13822] = 38829,
	[13693] = 38821,
	[33997] = 38935,
	[34005] = 38941,
	[13794] = 38826,
	[13626] = 38804,
	[44484] = 38951,
	[44492] = 38955,
	[44500] = 38959,
	[44508] = 38961,
	[71692] = 50816,
	[44524] = 38965,
	[13419] = 38789,
	[7793] = 38781,
	[7748] = 38773,
	[44556] = 38969,
	[60653] = 44455,
	[47899] = 39004,
	[59625] = 43987,
	[44588] = 38975,
	[44596] = 38982,
	[63746] = 45628,
	[47672] = 39001,
	[23803] = 38883,
	[44576] = 38972,
	[13836] = 38830,
	[44598] = 38984,
	[27982] = 38924,
	[42620] = 38947,
	[23800] = 38880,
	[13846] = 38832,
	[25083] = 38893,
	[13642] = 38809,
	[33990] = 38928,
	[23804] = 38884,
	[34006] = 38942,
	[13858] = 38833,
	[60714] = 44467,
	[20011] = 38855,
	[20015] = 38859,
	[47051] = 39000,
	[20023] = 38863,
	[60767] = 44470,
	[13617] = 38801,
	[20035] = 38874,
	[27944] = 38904,
	[27948] = 38908,
	[13689] = 38820,
	[13882] = 38835,
	[27960] = 38913,
	[13631] = 38805,
	[44589] = 38976,
	[27972] = 38920,
	[13637] = 38807,
	[13380] = 38788,
	[44621] = 38988,
	[44629] = 38991,
	[13663] = 38818,
	[7859] = 38783,
	[44633] = 38995,
	[7861] = 38784,
	[13653] = 38813,
	[7863] = 38785,
	[13657] = 38815,
	[13659] = 38816,
	[13661] = 38817,
	[7867] = 38786,
	[13948] = 38851,
	[20034] = 38873,
	[20012] = 38856,
	[27906] = 38899,
	[44494] = 38956,
	[46594] = 38999,
	[44510] = 38963,
	[60621] = 44453,
	[62256] = 44947,
	[7771] = 38775,
	[13622] = 38803,
	[13687] = 38819,
	[60623] = 38986,
	[13378] = 38787,
	[59619] = 44497,
	[27837] = 38896,
	[44590] = 38977,
	[60663] = 44457,
	[22749] = 38877,
	[7457] = 38771,
	[47766] = 39002,
	[44630] = 38992,
	[44383] = 38949,
	[13931] = 38842,
	[44509] = 38962,
	[25072] = 38885,
	[23801] = 38881,
	[13464] = 38791,
	[25084] = 38894,
	[34010] = 38946,
	[33992] = 38930,
	[25080] = 38890,
	[27905] = 38898,
	[27975] = 38921,
	[20008] = 38852,
	[27917] = 38903,
	[20016] = 38860,
	[20020] = 38862,
	[20024] = 38864,
	[20028] = 38867,
	[20032] = 38871,
	[20036] = 38875,
	[27945] = 38905,
	[64441] = 46026,
	[13868] = 38834,
	[27957] = 38911,
	[27961] = 38914,
	[47898] = 39003,
	[44591] = 38978,
	[62959] = 45060,
	[27977] = 38922,
	[27981] = 38923,
	[44623] = 38989,
	[44631] = 38993,
	[60606] = 44449,
	[20026] = 38866,
	[13522] = 38795,
	[33991] = 38929,
	[33999] = 38936,
	[13607] = 38799,
	[7418] = 38679,
	[25079] = 38889,
	[33993] = 38931,
	[34001] = 38937,
	[34009] = 38945,
	[44529] = 38967,
	[62948] = 45056,
	[28004] = 38927,
	[47901] = 39006,
	[34007] = 38943,
	[34008] = 38944,
	[21931] = 38876,
	[52775] = 74244,
	[52776] = 74246,
	[52761] = 74225,
	[52746] = 74193,
	[74242] = 52774,
	[74246] = 52776,
	[74250] = 52779,
	[74191] = 52744,
	[74132] = 52687,
	[74199] = 52750,
	[74207] = 52754,
	[74211] = 52755,
	[74223] = 52760,
	[74231] = 52765,
	[74235] = 52768,
	[74239] = 52772,
	[74247] = 52777,
	[74251] = 52780,
	[74192] = 52745,
	[74200] = 52751,
	[74212] = 52756,
	[74220] = 52759,
	[74232] = 52766,
	[74236] = 52769,
	[95471] = 68134,
	[74244] = 52775,
	[74248] = 52778,
	[74189] = 52743,
	[74193] = 52746,
	[74197] = 52748,
	[74201] = 52752,
	[74213] = 52757,
	[74225] = 52761,
	[74229] = 52763,
	[74237] = 52770,
	[74254] = 52783,
	[74253] = 52782,
	[74255] = 52784,
	[74198] = 52749,
	[74202] = 52753,
	[74256] = 52785,
	[74252] = 52781,
	[74214] = 52758,
	[74240] = 52773,
	[74226] = 52762,
	[74230] = 52764,
	[74234] = 52767,
	[74195] = 52747,
	[74238] = 52771,
	[96264] = 68784,
	[96261] = 68785,
	[96262] = 68786,
}

-- used to lookup the slot number of the enchant used by TradeSkillMaster_Crafting
-- index = itemID of enchant's scroll
-- value = slot number
Enchanting.slot = {
	[38972]=1, -- 2H Weapon
	[38991]=1, -- 2H Weapon
	[43987]=1, -- 2H Weapon
	[44467]=1, -- 2H Weapon
	[45056]=1, -- 2H Weapon
	[38965]=1, -- 2H Weapon
	[38995]=1, -- 2H Weapon
	[38988]=1, -- 2H Weapon
	[38992]=1, -- 2H Weapon
	[52747]=1, -- 2H Weapon
	[38963]=1, -- 2H Weapon
	[38981]=1, -- 2H Weapon
	[45060]=1, -- 2H Weapon
	[46026]=1, -- 2H Weapon
	[46098]=1, -- 2H Weapon
	[44463]=1, -- 2H Weapon
	[44466]=1, -- 2H Weapon
	[44493]=1, -- 2H Weapon
	[38923]=1, -- 2H Weapon
	[38924]=1, -- 2H Weapon
	[38925]=1, -- 2H Weapon
	[38948]=1, -- 2H Weapon
	[38998]=1, -- 2H Weapon
	[44497]=1, -- 2H Weapon
	[38922]=1, -- 2H Weapon
	[38926]=1, -- 2H Weapon
	[38927]=1, -- 2H Weapon
	[44453]=1, -- 2H Weapon
	[38884]=1, -- 2H Weapon
	[38919]=1, -- 2H Weapon
	[38920]=1, -- 2H Weapon
	[38921]=1, -- 2H Weapon
	[38946]=1, -- 2H Weapon
	[38947]=1, -- 2H Weapon
	[38917]=1, -- 2H Weapon
	[38918]=1, -- 2H Weapon
	[38883]=1, -- 2H Weapon
	[38916]=1, -- 2H Weapon
	[38871]=1, -- 2H Weapon
	[38874]=1, -- 2H Weapon
	[38873]=1, -- 2H Weapon
	[38870]=1, -- 2H Weapon
	[38875]=1, -- 2H Weapon
	[38877]=1, -- 2H Weapon
	[38878]=1, -- 2H Weapon
	[38869]=1, -- 2H Weapon
	[38872]=1, -- 2H Weapon
	[38879]=1, -- 2H Weapon
	[38880]=1, -- 2H Weapon
	[38896]=1, -- 2H Weapon
	[38868]=1, -- 2H Weapon
	[38838]=1, -- 2H Weapon
	[38848]=1, -- 2H Weapon
	[38845]=1, -- 2H Weapon
	[38840]=1, -- 2H Weapon
	[38822]=1, -- 2H Weapon
	[38821]=1, -- 2H Weapon
	[38876]=1, -- 2H Weapon
	[38813]=1, -- 2H Weapon
	[38814]=1, -- 2H Weapon
	[38796]=1, -- 2H Weapon
	[38794]=1, -- 2H Weapon
	[38788]=1, -- 2H Weapon
	[38772]=1, -- 2H Weapon
	[38779]=1, -- 2H Weapon
	[38780]=1, -- 2H Weapon
	[38781]=1, -- 2H Weapon
	[52748]=1, -- 2H Weapon
	[52755]=1, -- 2H Weapon
	[52760]=1, -- 2H Weapon
	[52761]=1, -- 2H Weapon
	[52774]=1, -- 2H Weapon
	[52775]=1, -- 2H Weapon
	[52776]=1, -- 2H Weapon
	[68134]=1, -- 2H Weapon
	[38986]=2, -- Boots
	[39006]=2, -- Boots
	[38976]=2, -- Boots
	[52743]=2, -- Boots
	[52750]=2, -- Boots
	[52757]=2, -- Boots
	[52769]=2, -- Boots
	[52771]=2, -- Boots
	[52781]=2, -- Boots
	[52782]=2, -- Boots
	[38966]=2, -- Boots
	[38910]=2, -- Boots
	[38974]=2, -- Boots
	[38943]=2, -- Boots
	[38944]=2, -- Boots
	[44469]=2, -- Boots
	[38961]=2, -- Boots
	[44449]=2, -- Boots
	[37603]=2, -- Boots
	[38909]=2, -- Boots
	[38908]=2, -- Boots
	[38863]=2, -- Boots
	[38864]=2, -- Boots
	[38862]=2, -- Boots
	[38844]=2, -- Boots
	[38837]=2, -- Boots
	[45628]=2, -- Boots
	[38830]=2, -- Boots
	[38819]=2, -- Boots
	[38810]=2, -- Boots
	[38807]=2, -- Boots
	[38785]=2, -- Boots
	[38786]=2, -- Boots
	[38997]=3, -- Bracers
	[38984]=3, -- Bracers
	[52746]=3, -- Bracers
	[52752]=3, -- Bracers
	[52763]=3, -- Bracers
	[52766]=3, -- Bracers
	[52770]=3, -- Bracers
	[52772]=3, -- Bracers
	[52778]=3, -- Bracers
	[52785]=3, -- Bracers
	[38980]=3, -- Bracers
	[38987]=3, -- Bracers
	[44947]=3, -- Bracers
	[38968]=3, -- Bracers
	[38903]=3, -- Bracers
	[38971]=3, -- Bracers
	[44470]=3, -- Bracers
	[44815]=3, -- Bracers
	[38902]=3, -- Bracers
	[38901]=3, -- Bracers
	[38900]=3, -- Bracers
	[38882]=3, -- Bracers
	[38899]=3, -- Bracers
	[38898]=3, -- Bracers
	[38897]=3, -- Bracers
	[38937]=3, -- Bracers
	[38855]=3, -- Bracers
	[38938]=3, -- Bracers
	[38854]=3, -- Bracers
	[38881]=3, -- Bracers
	[38853]=3, -- Bracers
	[38852]=3, -- Bracers
	[38849]=3, -- Bracers
	[38846]=3, -- Bracers
	[38842]=3, -- Bracers
	[38832]=3, -- Bracers
	[38829]=3, -- Bracers
	[38817]=3, -- Bracers
	[38811]=3, -- Bracers
	[38812]=3, -- Bracers
	[38809]=3, -- Bracers
	[38803]=3, -- Bracers
	[38797]=3, -- Bracers
	[38793]=3, -- Bracers
	[38783]=3, -- Bracers
	[38777]=3, -- Bracers
	[38778]=3, -- Bracers
	[38774]=3, -- Bracers
	[38771]=3, -- Bracers
	[38768]=3, -- Bracers
	[38679]=3, -- Bracers
	[68784]=3, -- Bracers
	[68785]=3, -- Bracers
	[68786]=3, -- Bracers
	[38989]=4, -- Chest
	[39005]=4, -- Chest
	[38975]=4, -- Chest
	[52744]=4, -- Chest
	[52751]=4, -- Chest
	[52758]=4, -- Chest
	[52765]=4, -- Chest
	[52779]=4, -- Chest
	[52780]=4, -- Chest
	[39002]=4, -- Chest
	[38955]=4, -- Chest
	[44465]=4, -- Chest
	[38962]=4, -- Chest
	[38999]=4, -- Chest
	[38912]=4, -- Chest
	[38913]=4, -- Chest
	[38930]=4, -- Chest
	[38928]=4, -- Chest
	[38911]=4, -- Chest
	[38865]=4, -- Chest
	[38929]=4, -- Chest
	[38867]=4, -- Chest
	[38866]=4, -- Chest
	[38847]=4, -- Chest
	[38841]=4, -- Chest
	[38833]=4, -- Chest
	[38824]=4, -- Chest
	[38818]=4, -- Chest
	[38808]=4, -- Chest
	[38804]=4, -- Chest
	[38799]=4, -- Chest
	[38798]=4, -- Chest
	[38782]=4, -- Chest
	[38776]=4, -- Chest
	[38773]=4, -- Chest
	[38767]=4, -- Chest
	[38769]=4, -- Chest
	[38766]=4, -- Chest
	[38978]=5, -- Cloak
	[38993]=5, -- Cloak
	[39003]=5, -- Cloak
	[39004]=5, -- Cloak
	[52745]=5, -- Cloak
	[52753]=5, -- Cloak
	[52764]=5, -- Cloak
	[52767]=5, -- Cloak
	[52773]=5, -- Cloak
	[52777]=5, -- Cloak
	[38950]=5, -- Cloak
	[38956]=5, -- Cloak
	[38959]=5, -- Cloak
	[38969]=5, -- Cloak
	[38977]=5, -- Cloak
	[38982]=5, -- Cloak
	[38973]=5, -- Cloak
	[39000]=5, -- Cloak
	[44456]=5, -- Cloak
	[44457]=5, -- Cloak
	[39001]=5, -- Cloak
	[38891]=5, -- Cloak
	[38892]=5, -- Cloak
	[38893]=5, -- Cloak
	[38894]=5, -- Cloak
	[38895]=5, -- Cloak
	[38941]=5, -- Cloak
	[38942]=5, -- Cloak
	[38915]=5, -- Cloak
	[38939]=5, -- Cloak
	[38914]=5, -- Cloak
	[38940]=5, -- Cloak
	[38859]=5, -- Cloak
	[38858]=5, -- Cloak
	[38835]=5, -- Cloak
	[38825]=5, -- Cloak
	[38826]=5, -- Cloak
	[38815]=5, -- Cloak
	[38806]=5, -- Cloak
	[38795]=5, -- Cloak
	[38784]=5, -- Cloak
	[38790]=5, -- Cloak
	[38789]=5, -- Cloak
	[38775]=5, -- Cloak
	[38770]=5, -- Cloak
	[38967]=6, -- Gloves
	[38979]=6, -- Gloves
	[38990]=6, -- Gloves
	[44458]=6, -- Gloves
	[38964]=6, -- Gloves
	[52687]=6, -- Gloves
	[52749]=6, -- Gloves
	[52756]=6, -- Gloves
	[52759]=6, -- Gloves
	[52783]=6, -- Gloves
	[52784]=6, -- Gloves
	[38953]=6, -- Gloves
	[38960]=6, -- Gloves
	[38951]=6, -- Gloves
	[38932]=6, -- Gloves
	[38935]=6, -- Gloves
	[38885]=6, -- Gloves
	[38886]=6, -- Gloves
	[38887]=6, -- Gloves
	[38888]=6, -- Gloves
	[38889]=6, -- Gloves
	[38890]=6, -- Gloves
	[38936]=6, -- Gloves
	[50816]=6, -- Gloves
	[38933]=6, -- Gloves
	[38934]=6, -- Gloves
	[38931]=6, -- Gloves
	[38857]=6, -- Gloves
	[38856]=6, -- Gloves
	[38850]=6, -- Gloves
	[38851]=6, -- Gloves
	[38834]=6, -- Gloves
	[38836]=6, -- Gloves
	[38831]=6, -- Gloves
	[38827]=6, -- Gloves
	[38823]=6, -- Gloves
	[38800]=6, -- Gloves
	[38801]=6, -- Gloves
	[38802]=6, -- Gloves
	[52754]=7, -- Shield
	[52762]=7, -- Shield
	[52768]=7, -- Shield
	[44455]=7, -- Shield
	[38907]=7, -- Shield
	[38954]=7, -- Shield
	[38906]=7, -- Shield
	[38949]=7, -- Shield
	[38905]=7, -- Shield
	[38945]=7, -- Shield
	[38904]=7, -- Shield
	[38860]=7, -- Shield
	[38861]=7, -- Shield
	[38843]=7, -- Shield
	[38839]=7, -- Shield
	[38828]=7, -- Shield
	[38820]=7, -- Shield
	[38816]=7, -- Shield
	[38805]=7, -- Shield
	[38792]=7, -- Shield
	[38791]=7, -- Shield
	[38787]=7, -- Shield
	[45056]=8, -- Staff
	[45060]=8, -- Staff
	[38972]=9, -- Weapon
	[38991]=9, -- Weapon
	[43987]=9, -- Weapon
	[44467]=9, -- Weapon
	[38965]=9, -- Weapon
	[38995]=9, -- Weapon
	[38988]=9, -- Weapon
	[52747]=9, -- Weapon
	[38963]=9, -- Weapon
	[46026]=9, -- Weapon
	[46098]=9, -- Weapon
	[44466]=9, -- Weapon
	[44493]=9, -- Weapon
	[38923]=9, -- Weapon
	[38924]=9, -- Weapon
	[38925]=9, -- Weapon
	[38948]=9, -- Weapon
	[38998]=9, -- Weapon
	[44497]=9, -- Weapon
	[38926]=9, -- Weapon
	[38927]=9, -- Weapon
	[44453]=9, -- Weapon
	[38884]=9, -- Weapon
	[38920]=9, -- Weapon
	[38921]=9, -- Weapon
	[38946]=9, -- Weapon
	[38947]=9, -- Weapon
	[38917]=9, -- Weapon
	[38918]=9, -- Weapon
	[38883]=9, -- Weapon
	[38916]=9, -- Weapon
	[38871]=9, -- Weapon
	[38873]=9, -- Weapon
	[38870]=9, -- Weapon
	[38877]=9, -- Weapon
	[38878]=9, -- Weapon
	[38872]=9, -- Weapon
	[38879]=9, -- Weapon
	[38880]=9, -- Weapon
	[38868]=9, -- Weapon
	[38838]=9, -- Weapon
	[38848]=9, -- Weapon
	[38840]=9, -- Weapon
	[38821]=9, -- Weapon
	[38876]=9, -- Weapon
	[38813]=9, -- Weapon
	[38814]=9, -- Weapon
	[38794]=9, -- Weapon
	[38779]=9, -- Weapon
	[38780]=9, -- Weapon
	[52748]=9, -- Weapon
	[52755]=9, -- Weapon
	[52760]=9, -- Weapon
	[52761]=9, -- Weapon
	[52774]=9, -- Weapon
	[52775]=9, -- Weapon
	[52776]=9, -- Weapon
}