-- Create a frame for handling combat log events
local frame = CreateFrame("Frame")
local playername = "unknown"
frame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")

-- Event handler function
frame:SetScript("OnEvent", function(self, event, ...)
	playername = UnitName("player")
    -- Correctly unpack combat log arguments for WoW 3.3.5
    local timestamp, subEvent, hideCaster, sourceGUID, sourceName, sourceFlags, 
    destGUID, destName, spellID, spellName, spellSchool, auraType = select(1, ...)

    -- Debugging: Print the relevant information
    -- print("SubEvent:", subEvent, "SpellID:", spellID, "TargetGUID:", destGUID, "TargetName:", destName)

    -- Check if the sub-event is "SPELL_AURA_APPLIED"
    if subEvent == "SPELL_AURA_APPLIED" then
        -- Check if the spell is Sap (spell ID: 11297) and the target is the player
        if spellID == 11297 and destGUID == playername then
            -- Send "Sapped" messages to party and say chat
            SendChatMessage("Sapped by " .. sourceGUID .. ".", "PARTY")
            SendChatMessage("Sapped by " .. sourceGUID .. ".", "SAY")
        end
    end
end)
